//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void  TForm1::main()
{
 char    *stime[30],*etime[30];
 __int64  tick1,tick2;

      tick1 = GetTickCount();

      Form1->Cursor = crHourGlass;

      fid    = fopen("log.txt","wt");

      time(&t1);
      *stime = ctime(&t1);
      fprintf(fid,"*** pazul started : %s \n",*stime);

      Edit1->Text = *stime;
      Edit3->Text = IntToStr(time(&t2)-t1);

      Form1->Refresh();

      exec();

      tick2 = GetTickCount();
      result = (int) (tick2 -tick1);

      time(&t2);
      *etime = ctime(&t2);
      fprintf(fid,"\n*** pazul  ended  time = %d ms  : %s \n",result,*etime);

      Edit2->Text = *etime;
      Edit3->Text = IntToStr(t2-t1);
      Edit4->Text = IntToStr(result);

      fclose(fid);

  // reset cursor mark
      Form1->Cursor = crDefault;

 }
//---------------------------------------------------------------------------
void    TForm1::exec()
{
 int    c,lb,t,rc;
 u64    w;
  __int64  t1,t2;


        panel = 0xfffffffffffffffeL;

        w = panel;
        c = 0;
        while (w) { c++; w &= w-1; }

        sprintf(str,"*** init (%d) ***",c);
        printPanel(str,panel);
        fprintf(fid,"\n");

        t1 = GetTickCount();

        init();
        lb  = LBE(c);
        Ans = 0;
        for (MaxHand=lb; Ans == 0; MaxHand++) {
            t2 = GetTickCount();
            t  = (t2 - t1) / 1000;
            fprintf(fid,"----- searching  Hand = %2d    time =%6d\n",MaxHand,t);
            fflush(fid);

            init();
            search(0,c,0,-1);
        }

  }
//---------------------------------------------------------------------------
void     TForm1::init()
{
 int    k;
 const  incr[] = { 1,8,-1,-8,9,7,-9,-7 };

        bitmask[0] = 1;
        for (k=1; k<64; k++)  bitmask[k] = bitmask[k-1] << 1;

        for (k=0; k<8; k++)  INCR[k] = incr[k];

        Boundary[0] = 0x8080808080808080L;
        Boundary[1] = 0xff00000000000000L;
        Boundary[2] = 0x0101010101010101L;
        Boundary[3] = 0x00000000000000ffL;
        Boundary[4] = Boundary[0] | Boundary[1];
        Boundary[5] = Boundary[1] | Boundary[2];
        Boundary[6] = Boundary[2] | Boundary[3];
        Boundary[7] = Boundary[3] | Boundary[0];


        for (k=0; k<=8; k++)  Syn[k] = 0;
        for (k=0; k<8; k++)   {  X[k] = Y[k] = 0; }
        for (k=0; k<=14; k++) {  U[k] = V[k] = 0; }

        for (k=0; k<64; k++)  if (panel & bitmask[k])  setSyn(k,1);

 }
//---------------------------------------------------------------------------
int     TForm1::search(int Hand,int Rcnt,int P,int Dir)
{
 int    dir2,p2,hand2,cnt2,lb,rc;
 u64    c;

        if (Rcnt == 0) {
            Pos[Hand] = P;
            sprintf(str,"+++ No. %d +++",++Ans);
            printPos(str,Hand);
            return 0;
        }

        lb = LBE(Rcnt);

        for (dir2=0; dir2<8; dir2++) {
            if (Boundary[dir2] & bitmask[P])  continue;

            if (dir2 != Dir) {
                if ((Hand + lb) > MaxHand)    continue;
                if (Hand == MaxHand)          continue;

                if ((Hand == 0) && (dir2 == 1))   continue;
                if (((Hand == 1) && (Dir == 4)) &&
                    ((dir2 == 1) || (dir2 == 2) || (dir2 == 5)))  continue;

                hand2 = Hand + 1;
                Pos[Hand] = P;
            }
            else  hand2 = Hand;

            p2 = P + INCR[dir2];
            c  = panel & bitmask[p2];
            if (c) {
                cnt2  = Rcnt - 1;
                panel ^= c;
                setSyn(p2,-1);
            }
            else {
                cnt2 = Rcnt;
            }

            rc = search(hand2,cnt2,p2,dir2);
            if (rc)  return rc;

            if (c) {
                panel ^= c;
                setSyn(p2,+1);
            }
        }
        return 0;
 }
//---------------------------------------------------------------------------
int     TForm1::LBE(int Cnt)
{
 int    cnt,hand,k,h;


        hand = 0;
        cnt  = Cnt;
        Syn[7] += Syn[8];
        for (k=7; k>0; k--) {
            if (Syn[k] == 0)  continue;
            h = (cnt + k - 1) / k;
            if (h <= Syn[k])  { hand += h; break; }
            hand += Syn[k];
            cnt  -= Syn[k] * k;
        }
        Syn[7] -= Syn[8];
        return  hand;
 }
//---------------------------------------------------------------------------
void    TForm1::setSyn(int P,int D)
{
 int    x,y,u,v;

        x = P & 0x07;
        y = P >> 3;
        u = x + y;
        v = x - y + 7;

        Syn[X[x]]--;
        X[x] += D;
        Syn[X[x]]++;

        Syn[Y[y]]--;
        Y[y] += D;
        Syn[Y[y]]++;

        Syn[U[u]]--;
        U[u] += D;
        Syn[U[u]]++;

        Syn[V[v]]--;
        V[v] += D;
        Syn[V[v]]++;
 }
//---------------------------------------------------------------------------
void    TForm1::printPanel(char ID[],u64 Panel)
{
 u64    m;
 int    i,j;

        fprintf(fid,"\n%s\n",ID);

        m = Panel;
        for (i=0; i<8; i++) {
            for (j=0; j<8; j++) {
                fprintf(fid," %d",m & 0x01);
                m = m >>1;
            }
            fprintf(fid,"\n");
        }
        fflush(fid);
 }
//---------------------------------------------------------------------------
void    TForm1::printPos(char ID[],int Hand)
{
 int    h,x,y;

        fprintf(fid,"\n%s :",ID);

        for (h=0; h<=Hand; h++) {
            x = Pos[h] & 0x07;
            y = Pos[h] >> 3;
            (h==0) ? fprintf(fid," (%d,%d)",y,x) : fprintf(fid,"(%d,%d)",y,x);
        }
        fprintf(fid,"\n");
        fflush(fid);
 }
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClick(TObject *Sender)
{
     main();
}
//---------------------------------------------------------------------------
